document.addEventListener('DOMContentLoaded', () => {
    const storageApi = (typeof browser !== 'undefined') ? browser.storage.local : chrome.storage.local;
    const input = document.getElementById('apiKey');
    const btn = document.getElementById('save');
    const status = document.getElementById('status');

    storageApi.get(['apiKey'], (res) => {
        if (res.apiKey) input.value = res.apiKey;
    });

    btn.addEventListener('click', () => {
        const key = input.value.trim();
        if (!key) return;

        btn.innerText = 'СОХРАНЕНИЕ...';
        storageApi.set({ apiKey: key }, () => {
            btn.innerText = 'АВТОРИЗОВАТЬСЯ';
            status.style.display = 'block';
            setTimeout(() => status.style.display = 'none', 3000);
        });
    });
});